/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.MsVersionInfo;
import com.ibm.hsc.common.util.PIConcMaintDiscardHandler;
import com.ibm.hsc.fsp.FspSvrAsyncSubscription;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.fsp.lockmgr.FspLockMgr;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecAsyncEvtHandler;
import com.ibm.hsc.objmgr.cec.OmCecBpcIpPush;
import com.ibm.hsc.objmgr.cec.OmCecHscInfoUpdater;
import com.ibm.hsc.objmgr.cec.OmCecLongRunningTask;
import com.ibm.hsc.objmgr.cec.OmCecStateChangeAct;
import com.ibm.hsc.objmgr.cec.OmCecUpdater;
import com.ibm.hsc.objmgr.cec.OmIoResAct;
import com.ibm.hsc.objmgr.cec.OmPendingThreadHandler;
import com.ibm.hsc.objmgr.cec.action.MegaMouthActionHandler;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.objmgr.sysprof.OmSysProfMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecMgr
extends OmSysMgr {
    private PIHMCSaveArea mSaveArea = null;
    private OmCecUpdater mCecUpdater = null;
    private Hashtable mLparMgrHash = new Hashtable();
    private Hashtable mSysProfMgrHash = new Hashtable();
    private OmCecStateChangeAct mCecStateChangeAct = null;
    private OmCecAsyncEvtHandler mAsyncEvtHandler = null;
    private OmCecBpcIpPush mBpcIpPush = null;
    private boolean mPHYPRunning = false;
    private int mHvConfigState = 1;
    private PIConcMaintDiscardHandler mIOMaintDiscardHandler = null;
    private Hashtable mServerAdapterTable = new Hashtable();
    private Hashtable mClientAdapterTable = new Hashtable();
    private Hashtable mIncompatibleClientAdapterTable = new Hashtable();
    private UnsignedInt8 mRecommandedHptRatio = null;
    private FspLockMgr mFspLockMgr = null;
    private Hashtable mPhyIODrcIndexTable = new Hashtable();
    private Hashtable mPhyIODrcNameTable = new Hashtable();
    private Hashtable mPhyIODrcIndexToFullLocTable = new Hashtable();
    private FspLockHelper mCodeUpdateLock = null;
    private Vector mLongRunningThreadList = new Vector();
    private static boolean sGetCecStateV1 = false;

    public OmCecMgr(FspQueryData fspQueryData, byte[] byArray) throws RException, PIHscCmdMgrException {
        super(fspQueryData, byArray);
        this.mFspLockMgr = new FspLockMgr(this);
        this.mBpcIpPush = new OmCecBpcIpPush(this);
        this.initialize(fspQueryData, byArray);
        this.mIOMaintDiscardHandler = new PIConcMaintDiscardHandler(this.getCecName());
        System.out.println("created cec mgr");
    }

    protected void createAsyncHandler() {
        System.out.println("Create the async event handler");
        this.mAsyncEvtHandler = new OmCecAsyncEvtHandler(this);
        this.mAsyncHandler = this.mAsyncEvtHandler;
    }

    protected void createRObject(FspQueryData fspQueryData, byte[] byArray) throws RException {
        int n = 254;
        System.out.println("initial event handler");
        this.mCecUpdater = new OmCecUpdater(this);
        this.mSysOid = this.mCecUpdater.createCecInst();
        this.mSysObj = this.mSysOid.getObject();
        this.mSysObj.setProperty(R50ComputerSystem.Index_State, (Object)new UnsignedInt8((short)n));
        this.mSysObj.setProperty(R50ComputerSystem.Index_SlaveFSPExists, (Object)new Boolean(false));
        this.mSysObj.setProperty(R50ComputerSystem.Index_InstalledCPUCount, (Object)new UnsignedInt16(0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_InstalledProcessors, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_InstalledMemory, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_ConfigurableProcUnits, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_MaxI5OSProcUnits, (Object)new UnsignedInt16(0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_ConfigurableMem, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_HypervisorMemoryUsage, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_CurAvailMem, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_PendAvailMem, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_CurAvailProcUnits, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_PendAvailProcUnits, (Object)new UnsignedInt32(0L));
        this.mSysObj.setProperty(R50ComputerSystem.Index_CurAvailInteractive, (Object)new UnsignedInt16(0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_PendAvailInteractive, (Object)new UnsignedInt16(0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_MaxHostingLpars, (Object)new UnsignedInt16(0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_UserDefinedName, (Object)fspQueryData.getIpAddress());
        UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)HardwareServerMessage.bytesToUInt(byArray, 0));
        this.mSysObj.setProperty(R50ComputerSystem.Index_Vport, (Object)unsignedInt32);
        System.out.println("vport: " + unsignedInt32);
        String string = this.getCmdServerFailedExtReasonStr(fspQueryData);
        System.out.println("reasonStr: " + string);
        this.mSysObj.setProperty(R50ComputerSystem.Index_OpPanelValue, (Object)string);
        System.out.println("creating the discard handler for i/o conc maint");
    }

    protected void sentCreationEvent() {
        this.mCecUpdater.sentCreationEvent();
    }

    public static OmCecMgr getCecMgr(String string) {
        return (OmCecMgr)sSysMgrHash.get(string);
    }

    public void updateCecAll() throws PIHscServerException {
        this.updateSysAll();
    }

    public void updateSysAll() throws PIHscServerException {
        this.updateCecAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCecAll(boolean bl) throws PIHscServerException {
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lock();
            if (bl) {
                this.mAsyncEvtHandler.reinitialize();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            fspLockHelper.unlock();
            try {
                RObject rObject = (RObject)this.getObject().clone();
                if (this.mCecStateChangeAct.setCecState(-1, 253)) {
                    this.sendModifiedIndication(rObject);
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            return;
        }
        try {
            this.mCecUpdater.update(fspLockHelper);
        }
        finally {
            fspLockHelper.unlock();
        }
    }

    protected boolean reinitialize() {
        boolean bl = false;
        this.mFspLockMgr.reinitialize(null, this.mCmdMgr.getConnState());
        int n = this.updIntfCapNoException();
        if (n == 1 || n == 3 || n == 5) {
            bl = true;
        }
        this.mBpcIpPush.initialize();
        return bl;
    }

    public String getCecName() {
        return this.mSysName;
    }

    public boolean isHypervisorRunning() {
        return this.mPHYPRunning;
    }

    public void setHypervisorRunning(boolean bl) {
        System.out.println("set phypRunning " + bl);
        this.mPHYPRunning = bl;
    }

    public Hashtable getLparMgrHash() {
        return this.mLparMgrHash;
    }

    public OmLparMgr getLparMgr(String string) throws RException {
        OmLparMgr omLparMgr = (OmLparMgr)this.mLparMgrHash.get(string);
        if (omLparMgr == null) {
            System.out.println("cannot find partition mgr " + string);
            System.out.println("mLparMgrHash " + this.mLparMgrHash);
        }
        return omLparMgr;
    }

    public void addLparMgr(OmLparMgr omLparMgr) throws RException {
        this.mLparMgrHash.put(omLparMgr.getLparName(), omLparMgr);
        System.out.println("add a lpar mgr for " + omLparMgr.getLparName());
    }

    public OmLparMgr createLparMgr(String string, String string2) throws RException, PIHscCmdMgrException {
        return OmLparMgr.createLparMgr(this, string, string2);
    }

    public OmLparMgr createLparMgr(String string) throws RException, PIHscCmdMgrException {
        return this.createLparMgr(string, null);
    }

    public void deleteLparMgr(String string) {
        OmLparMgr omLparMgr = (OmLparMgr)this.mLparMgrHash.get(string);
        if (omLparMgr == null) {
            System.out.println("lpar mgr not found: " + string);
            return;
        }
        this.mLparMgrHash.remove(string);
    }

    public void deleteLpar(String string, boolean bl) throws PIHscServerException {
        System.out.println("delete lpar: " + string);
        OmLparMgr omLparMgr = (OmLparMgr)this.mLparMgrHash.get(string);
        omLparMgr.deleteLpar(bl);
    }

    public void deleteSystemProfiles() throws RException {
        Vector vector = this.mSysObj.associatorNames(R50Define.AID_IBMHSC_CompSysProfile);
        RObject rObject = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            rObject = (RObject)iterator.next();
            rObject.deleteInstance();
        }
    }

    public Hashtable getSysProfMgrHash() {
        return this.mSysProfMgrHash;
    }

    public OmSysProfMgr getSysProfMgr(String string) throws RException {
        OmSysProfMgr omSysProfMgr = (OmSysProfMgr)this.mSysProfMgrHash.get(string);
        return omSysProfMgr;
    }

    public void setSaveArea(PIHMCSaveArea pIHMCSaveArea) {
        this.mSaveArea = pIHMCSaveArea;
    }

    public PIHMCSaveArea getSaveArea() {
        return this.mSaveArea;
    }

    public void loadSaveArea(FspLockHelper fspLockHelper) throws PIHscServerException {
        if (!this.isFspAvailable()) {
            System.out.println("fsp not available, stop loading Save Area");
            return;
        }
        if (this.mSaveArea == null) {
            this.mSaveArea = new PIHMCSaveArea(this, this.getFspVersion(), fspLockHelper);
        } else {
            System.out.println("rebuilding NVRAM");
            this.mSaveArea.rebuildNVRAM(this.getFspVersion(), fspLockHelper);
        }
    }

    public void setCecRecoveryState() {
        RObject rObject = (RObject)this.mSysObj.clone();
        try {
            if (this.getCecStateChangeAct().setCecState(-1, 251)) {
                System.out.println("set cec to recovery state");
                this.sendModifiedIndication(rObject);
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
        }
    }

    public int getCecState() throws PIHscServerException {
        int n = this.mCecUpdater.getCecState();
        return n;
    }

    private boolean isInvalidHmcState() {
        try {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)this.mSysObj.getProperty(R50ComputerSystem.Index_State);
            System.out.println("check invalid hmc state: " + unsignedInt8);
            return unsignedInt8.intValue() == 253 || unsignedInt8.intValue() == 251;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void rebuildFromPowerOn(FspLockHelper fspLockHelper) {
        try {
            System.out.println("cec is ready, begin rebuild");
            this.mCecUpdater.update(fspLockHelper);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ioDrawerChangeAction() {
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildIoDrawers();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean phypStateChangedAction() {
        if (this.isInvalidHmcState()) {
            return false;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            if (this.getCecStateChangeAct().handleCecStateChange(true, fspLockHelper)) {
                boolean bl = true;
                return bl;
            }
            if (!this.mPHYPRunning) {
                boolean bl = false;
                return bl;
            }
            this.mCecUpdater.rebuildPhypStates();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cecStateChangedAction(boolean bl) {
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            boolean bl2 = this.getCecStateChangeAct().handleCecStateChange(bl, fspLockHelper);
            return bl2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cecAvailResChangedAction() {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildAvailRes();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public OmCecStateChangeAct getCecStateChangeAct() {
        if (this.mCecStateChangeAct == null) {
            this.mCecStateChangeAct = new OmCecStateChangeAct(this);
        }
        return this.mCecStateChangeAct;
    }

    public void cecNameChanged() {
        this.mCecUpdater.rebuildCecName();
    }

    public void cecSrcChanged() {
        this.mCecUpdater.rebuildCecSrc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAreaChanged() {
        if (this.isInvalidHmcState()) {
            try {
                this.updateCecAll(false);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildChangedNvram(fspLockHelper);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lparVspChanged(int n) {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            OmLparMgr omLparMgr = this.getLparMgr("" + n + "*" + this.mSysName);
            if (omLparMgr == null) {
                System.out.println("lpar " + n + " does not exist");
                return;
            }
            RObjectId rObjectId = omLparMgr.getObjectId();
            fspLockHelper.addLparLock(rObjectId);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildChangedLparVsps(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void lparVspSrcChanged(int n) {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        try {
            OmLparMgr omLparMgr = this.getLparMgr("" + n + "*" + this.mSysName);
            if (omLparMgr == null) {
                System.out.println("lpar " + n + " does not exist");
                return;
            }
            RObjectId rObjectId = omLparMgr.getObjectId();
            this.mCecUpdater.rebuildChangedLparVspSrcs(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ioInfoChanged(Vector vector, Vector vector2) {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addAllSlotLock(this.mSysOid);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildChangedIoInfo(vector, vector2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lparChanged(int n, int n2) {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            RObjectId rObjectId = this.getLparMgr("" + n + "*" + this.mSysName).getObjectId();
            fspLockHelper.addNvramLock(this.mSysOid);
            fspLockHelper.addLparLock(rObjectId);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildChangedLpar(n, n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void codChanged(FspCodAsyncEventData fspCodAsyncEventData) {
        if (this.isInvalidHmcState() || !this.mPHYPRunning) {
            return;
        }
        FspLockHelper fspLockHelper = new FspLockHelper(this.mFspLockMgr, 0);
        try {
            fspLockHelper.addCecLock(this.mSysOid);
            fspLockHelper.lockAsync();
            this.mCecUpdater.rebuildCodChanges(fspCodAsyncEventData);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        finally {
            try {
                fspLockHelper.unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void handleDiscardMsg(Hashtable hashtable, int n) {
        this.mIOMaintDiscardHandler.handleUnknownHypPipeResponse(n, hashtable);
    }

    public void sendBroadcastMsg(UnsignedInt32 unsignedInt32, String string, UnsignedInt16 unsignedInt16, String string2, UnsignedInt16 unsignedInt162, UnsignedInt32 unsignedInt322, byte[] byArray) throws PIHscServerException {
        int n;
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = new byte[byArray2.length + byArray.length + 12];
        HardwareServerMessage.shortToBytes(unsignedInt16.shortValue(), byArray3, 0);
        HardwareServerMessage.shortToBytes(unsignedInt162.shortValue(), byArray3, 2);
        HardwareServerMessage.intToBytes(unsignedInt322.intValue(), byArray3, 4);
        HardwareServerMessage.shortToBytes((short)byArray2.length, byArray3, 8);
        HardwareServerMessage.shortToBytes((short)byArray.length, byArray3, 10);
        int n2 = byArray2.length + 12;
        for (n = 12; n < n2; ++n) {
            byArray3[n] = byArray2[n + 12];
        }
        for (n = n2; n < byArray.length + n2; ++n) {
            byArray3[n] = byArray2[n + n2];
        }
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(1);
        if (string == null) {
            unsignedInt8 = new UnsignedInt8(-2);
        }
        this.mCmdHelper.broadcastMessage(unsignedInt8, unsignedInt32, string, byArray3);
    }

    public CIMValue getIOHubs(Vector vector, Vector vector2) throws PIHscCmdMgrException, PIHscServerException {
        return MegaMouthActionHandler.getInstance().getIOHubs(vector, vector2, this.getCmdHelper());
    }

    public CIMValue getRioBuses(Vector vector, Vector vector2) throws PIHscCmdMgrException, PIHscServerException {
        return MegaMouthActionHandler.getInstance().getRioBuses(vector, vector2, this.getCmdHelper());
    }

    public CIMValue getRioTopology(Vector vector, Vector vector2) throws PIHscCmdMgrException, PIHscServerException {
        return MegaMouthActionHandler.getInstance().getRioTopology(vector, vector2, this.getCmdHelper());
    }

    public CIMValue setMultiHubMode(Vector vector, Vector vector2) throws PIHscCmdMgrException, PIHscServerException {
        return MegaMouthActionHandler.getInstance().setMultiHubMode(vector, vector2, this.getCmdHelper());
    }

    public CIMValue getMultiHubMode(Vector vector, Vector vector2) throws PIHscCmdMgrException, PIHscServerException {
        return MegaMouthActionHandler.getInstance().getMultiHubMode(vector, vector2, this.getCmdHelper());
    }

    public Hashtable getClientAdaptersTable() {
        return this.mClientAdapterTable;
    }

    public Hashtable getServerAdaptersTable() {
        return this.mServerAdapterTable;
    }

    public Hashtable getIncompatibleClients() {
        return this.mIncompatibleClientAdapterTable;
    }

    public UnsignedInt8 getRecommandedHptRatio() {
        return this.mRecommandedHptRatio;
    }

    public void setRecommandedHptRatio(UnsignedInt8 unsignedInt8) {
        this.mRecommandedHptRatio = unsignedInt8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sysDisconnected(long l) {
        try {
            this.mFspLockMgr.disconnect();
            this.mBpcIpPush.disconnect();
            this.stopLongRunningThreads();
            this.mAsyncEvtHandler.clearServerEventSubscriptions();
            RObject rObject = (RObject)this.getObject().clone();
            System.out.println("set cec state to no conn");
            Lock lock = Lock.getInstance("root/ibmhscS1_0", this.mSysName);
            try {
                lock.lock(1);
                if (this.getCecStateChangeAct().setCecState(-1, 254)) {
                    System.out.println("send out indication event for no conn");
                    this.sendModifiedIndication(rObject);
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public FspLockMgr getFspLockMgr() {
        return this.mFspLockMgr;
    }

    public FspLockHelper getCodeUpdateLock() {
        return this.mCodeUpdateLock;
    }

    public void setCodeUpdateLock(FspLockHelper fspLockHelper) {
        this.mCodeUpdateLock = fspLockHelper;
    }

    protected void unlockSysAll() throws PIHscServerException {
        this.mFspLockMgr.unlockAll();
    }

    public void deleteCecAll() throws PIHscServerException, RException {
        this.deleteSysAll();
    }

    public void deleteSysAll() throws PIHscServerException, RException {
        Object object;
        Object object2;
        Enumeration enumeration;
        this.mCmdMgr.close(true);
        System.out.println("removing io drawers");
        Vector vector = this.mSysObj.associators(R50Define.AID_IBMHSC_UsingIODrawer);
        OmIoResAct omIoResAct = new OmIoResAct(this);
        if (vector != null) {
            enumeration = vector.iterator();
            while (enumeration.hasNext()) {
                object2 = (RObject)enumeration.next();
                object = ((RObject)object2).associators(R50Define.AID_IBMHSC_UsingIODrawer);
                if (((Vector)object).size() > 1) continue;
                omIoResAct.deleteDrawer((RObject)object2);
            }
        }
        System.out.println("removing lpars");
        enumeration = this.mLparMgrHash.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (OmLparMgr)this.mLparMgrHash.get(object2);
            ((OmLparMgr)object).deleteLpar(false);
        }
        System.out.println("removing sysprofs");
        enumeration = this.mSysProfMgrHash.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (OmSysProfMgr)this.mSysProfMgrHash.get(object2);
            ((OmSysProfMgr)object).deleteSysProf();
        }
        System.out.println("removing hscinfo");
        this.mSysObj.deleteAssociated(R50Define.AID_IBMHSC_CompSysHscInfo);
        super.deleteSysAll();
    }

    public boolean updateServiceLparId(boolean bl) throws PIHscCmdMgrException, PIHscServerException, RException {
        boolean bl2 = false;
        UnsignedInt16 unsignedInt16 = this.mCmdHelper.getServiceLparId();
        System.out.println("[OM]update service lpar id: " + unsignedInt16);
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_ServPartID, (Object)unsignedInt16)) {
            bl2 = true;
            System.out.println("[OM]ServPartID = " + unsignedInt16);
        }
        if (bl) {
            Enumeration enumeration = this.mLparMgrHash.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                OmLparMgr omLparMgr = (OmLparMgr)this.mLparMgrHash.get(string);
                omLparMgr.updateServiceAuthority(true);
            }
        }
        return bl2;
    }

    public Hashtable getPhyIODrcIndexTable() {
        return this.mPhyIODrcIndexTable;
    }

    public Hashtable getPhyIODrcNameTable() {
        return this.mPhyIODrcNameTable;
    }

    public Hashtable getPhyIODrcIndexToFullLocTable() {
        return this.mPhyIODrcIndexToFullLocTable;
    }

    public String drcIndexToLocationCode(UnsignedInt32 unsignedInt32) {
        return (String)this.mPhyIODrcIndexTable.get(unsignedInt32);
    }

    public String drcIndexToFullLocCode(UnsignedInt32 unsignedInt32) {
        String string = (String)this.mPhyIODrcIndexToFullLocTable.get(unsignedInt32);
        if (string == null || string.length() <= 0) {
            string = Long.toHexString(unsignedInt32.longValue());
        } else {
            String string2 = string.substring(string.indexOf(32) + 1);
            string = string.substring(0, string.indexOf(42)) + " " + string2;
        }
        return string;
    }

    public FspSvrAsyncSubscription subscribeSvrEvent(int n, int n2, int n3) {
        return new FspSvrAsyncSubscription(this.mAsyncEvtHandler, n, n2, n3);
    }

    protected boolean repUpdateStateData(int n) throws RException {
        boolean bl = false;
        FspQueryData fspQueryData = this.mCmdMgr.getQueryData();
        if (fspQueryData == null) {
            return false;
        }
        if (n != 254 && n != 250) {
            int n2 = fspQueryData.getPendingPasswordChangeBitfield().intValue();
            if (this.setProperty("PasswordStatus", (Object)new UnsignedInt16(n2))) {
                bl = true;
            }
            int n3 = MsVersionInfo.isCompatible("V4R3.2", fspQueryData.getInterfaceVersionFamily().intValue(), fspQueryData.getFspType().intValue(), fspQueryData.getMajorVersion().intValue(), fspQueryData.getMinorVersion().intValue(), fspQueryData.getBrand().intValue());
            System.out.println("MsVersionInfo.isCompatible " + n3);
            if (n3 != 0) {
                n = 250;
            }
        }
        if (n == 14 || n == 4) {
            return false;
        }
        FspQueryData fspQueryData2 = this.mCmdMgr.getQueryData();
        if (fspQueryData2 != null && this.getObject().setProperty(R50ComputerSystem.Index_OpPanelValue, (Object)this.getCmdServerFailedExtReasonStr(fspQueryData2))) {
            bl = true;
        }
        if (this.getCecStateChangeAct().setCecState(-1, n)) {
            bl = true;
        }
        return bl;
    }

    protected boolean repUpdateConnData(int n, int n2, int n3, FspQueryData fspQueryData, boolean bl) throws RException {
        Object object;
        super.repUpdateConnData(n, n2, n3, fspQueryData, bl);
        boolean bl2 = false;
        Hashtable hashtable = this.mCmdMgr.getAllConnInfo();
        Enumeration enumeration = hashtable.elements();
        boolean bl3 = false;
        while (enumeration.hasMoreElements()) {
            object = (FspQueryData)enumeration.nextElement();
            if (((FspQueryData)object).getFspRole().intValue() != 2) continue;
            bl3 = true;
        }
        if (this.setProperty("SlaveFSPExists", (Object)new Boolean(bl3))) {
            bl2 = true;
        }
        if (this.mCmdMgr.getQueryData() == null) {
            return bl2;
        }
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_Vport, (Object)new UnsignedInt32((long)this.mCmdMgr.getVport()))) {
            bl2 = true;
        }
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_TtyVport, (Object)this.mCmdMgr.getQueryData().getStreamServerVportNumber())) {
            bl2 = true;
        }
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_Brand, (Object)this.mCmdMgr.getQueryData().getBrand())) {
            bl2 = true;
        }
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_IpAddress, (Object)this.mCmdMgr.getIPAddr())) {
            bl2 = true;
        }
        object = (String)this.mSysObj.getProperty(R50ComputerSystem.Index_UserDefinedName);
        System.out.println("uname: " + (String)object);
        if (object == null) {
            System.out.println("mCmdMgr.getIPAddr() " + this.mCmdMgr.getIPAddr());
            this.mSysObj.setProperty(R50ComputerSystem.Index_UserDefinedName, (Object)this.mCmdMgr.getIPAddr());
            bl2 = true;
        }
        System.out.println("mCmdMgr.getSPVersion " + this.mCmdMgr.getSPVersion());
        if (this.mSysObj.setProperty(R50ComputerSystem.Index_SPVersion, (Object)this.mCmdMgr.getSPVersion())) {
            bl2 = true;
        }
        if (n3 != 14 && n3 != 4) {
            String string = this.getCmdServerFailedExtReasonStr(this.mCmdMgr.getQueryData());
            System.out.println("set op panel val:" + string);
            if (this.mSysObj.setProperty(R50ComputerSystem.Index_OpPanelValue, (Object)string)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public String getFspVersion() {
        return this.mCmdMgr.getSPVersion();
    }

    public String getIPAddress() {
        return this.mCmdMgr.getIPAddr();
    }

    public int getNumberOfHmcSupported() {
        return 1;
    }

    public int getVPort() {
        return this.mCmdMgr.getVport();
    }

    public static void pushHscInfo() {
        Enumeration enumeration = sSysMgrHash.elements();
        while (enumeration.hasMoreElements()) {
            OmSysMgr omSysMgr = (OmSysMgr)enumeration.nextElement();
            if (!(omSysMgr instanceof OmCecMgr)) continue;
            OmCecMgr omCecMgr = (OmCecMgr)omSysMgr;
            OmCecHscInfoUpdater omCecHscInfoUpdater = new OmCecHscInfoUpdater(omCecMgr);
            try {
                omCecHscInfoUpdater.pushHscInfo();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static Vector getAllCecIpAddr() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = sSysMgrHash.elements();
        while (enumeration.hasMoreElements()) {
            OmCecMgr omCecMgr;
            String string;
            OmSysMgr omSysMgr = (OmSysMgr)enumeration.nextElement();
            if (!(omSysMgr instanceof OmCecMgr) || (string = (omCecMgr = (OmCecMgr)omSysMgr).getIPAddress()) == null) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public Object doLongRunningTask(OmCecLongRunningTask omCecLongRunningTask, Object[] objectArray, Lock lock) throws PIHscServerException {
        OmPendingThreadHandler omPendingThreadHandler = new OmPendingThreadHandler(this, omCecLongRunningTask, objectArray, lock);
        return omPendingThreadHandler.startLongRunningTask();
    }

    void regLongRunningThread(OmPendingThreadHandler omPendingThreadHandler) {
        System.out.println("regLongRunningThread" + omPendingThreadHandler.getName());
        this.mLongRunningThreadList.addElement(omPendingThreadHandler);
    }

    void deregLongRunningThread(OmPendingThreadHandler omPendingThreadHandler) {
        System.out.println("deregLongRunningThread" + omPendingThreadHandler.getName());
        this.mLongRunningThreadList.removeElement(omPendingThreadHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLongRunningThreads() {
        Vector vector = this.mLongRunningThreadList;
        synchronized (vector) {
            System.out.println("mLongRunningThreadList.size() " + this.mLongRunningThreadList.size());
            for (int i = 0; i < this.mLongRunningThreadList.size(); ++i) {
                OmPendingThreadHandler omPendingThreadHandler = (OmPendingThreadHandler)this.mLongRunningThreadList.elementAt(i);
                omPendingThreadHandler.forceStop();
            }
        }
    }

    public static int pushDownBpcIpInfo2AllCecs() {
        return OmCecBpcIpPush.pushDownBpcIpInfo2AllCecs(sSysMgrHash);
    }

    public int pushDownBpcIpInfo(byte[] byArray, long l) {
        return this.mBpcIpPush.pushDownBpcIpInfo(byArray, l);
    }

    public int getSysType() {
        return 0;
    }
}

